        //
//  MedicalItemCell.m
//  as350b3e
//
//  Created by Vadim Dagman on 4/3/14.
//
//

#import "MedicalItemCell.h"
#import "CommonDefs.h"
#import "MedicalPackage.h"
#import "UtilityCategories.h"

@implementation MedicalItemCell {
    
    __weak IBOutlet UIButton *selectButton_;
    __weak IBOutlet UITextField *stationTextField_;
    __weak IBOutlet UITextField *weightTextField_;
    __weak IBOutlet UITextField *armTextField_;
    __weak IBOutlet UITextField *momentTextField_;
    __weak IBOutlet UITextField *armLatTextField_;
    __weak IBOutlet UITextField *momentLatTextField_;
    __weak IBOutlet UILabel *stationNameLabel_;
    IBOutletCollection(UITextField) NSArray *momentFields_;
}

- (id)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        // Initialization code
    }
    return self;
}

- (void)awakeFromNib
{
    // Initialization code
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated
{
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

- (void)setItem:(MedicalItem *)item {
    selectButton_.selected = item.selected;
    weightTextField_.text = [NSString stringFromFloat:item.weight];
    armTextField_.text = [NSString stringFromFloat:item.arm];
    armLatTextField_.text = [NSString stringFromFloat:item.armLat];
    momentTextField_.text = [NSString stringFromFloat:item.moment];
    momentLatTextField_.text = [NSString stringFromFloat:item.momentLat];
    stationTextField_.text = @"";
    _item = item;
    
    [self setStationLabelText];
    
    [self enableMomentFields:(item.weight != 0)];
}

- (void)setStationLabelText {
    CGSize maxSize = CGSizeMake(stationNameLabel_.frame.size.width, CGFLOAT_MAX);
    stationNameLabel_.text = _item.station;
    stationNameLabel_.font = [UIFont systemFontOfSize:17];
    CGSize requiredSize = [stationNameLabel_ sizeThatFits:maxSize];
    while (requiredSize.height > stationNameLabel_.frame.size.height) {
        stationNameLabel_.font = [UIFont fontWithName:stationNameLabel_.font.fontName size:stationNameLabel_.font.pointSize-1];
        requiredSize = [stationNameLabel_ sizeThatFits:maxSize];
    }
    
}

- (void)enableMomentFields:(bool)enable {
    for (UITextField* textField in momentFields_) {
        textField.enabled = enable;
        if (!enable) {
            textField.alpha = 0.4;
        } else {
            textField.alpha = 1;
        }
    }
}

#pragma mark- Actions

- (IBAction)deleteAction:(id)sender {
    UIAlertView* alertView = [[UIAlertView alloc] initWithTitle:@"Are you sure you want to delete this item?" message:nil delegate:self cancelButtonTitle:@"Cancel" otherButtonTitles:@"Delete", nil];
    [alertView show];
}

- (IBAction)selectAction:(id)sender {
    selectButton_.selected = !selectButton_.selected;
    _item.selected = selectButton_.selected;
}

- (IBAction)editingDidBegin:(UITextField*)sender {
    sender.font = [UIFont systemFontOfSize:17];
    if (sender == stationTextField_) {
        stationTextField_.text = _item.station;
        stationNameLabel_.text = @"";
        stationTextField_.backgroundColor = [UIColor colorWithRed:210.0/255 green:254.0/255.0 blue:1 alpha:1];
    }
    [[NSNotificationCenter defaultCenter] postNotificationName:TEXT_FIELD_WILL_BEGIN_EDITING object:sender];
}

- (IBAction)valueChanged:(id)sender {
    [self updateFieldsForSender:sender];
}

- (IBAction)didEndEditing:(UITextField*)sender {
    [self updateFieldsForSender:sender];
    sender.backgroundColor = [UIColor whiteColor];
}

- (IBAction)didEndOnExit:(id)sender {
}

- (void)updateFieldsForSender:(id)sender {
    if (sender == weightTextField_) {
        _item.weight = [weightTextField_.text floatValue];
        armTextField_.text = [NSString stringFromFloat:_item.arm];
        armLatTextField_.text = [NSString stringFromFloat:_item.armLat];
        momentTextField_.text = [NSString stringFromFloat:_item.moment];
        momentLatTextField_.text = [NSString stringFromFloat:_item.momentLat];
        [self enableMomentFields:(_item.weight != 0)];
    } else if (sender == stationTextField_) {
        _item.station = stationTextField_.text;
        stationTextField_.text = @"";
        [self setStationLabelText];
    } else if (sender == armTextField_) {
        _item.arm = [armTextField_.text floatValue];
        momentTextField_.text = [NSString stringFromFloat:_item.moment];
    } else if (sender == armLatTextField_) {
        _item.armLat = [armLatTextField_.text floatValue];
        momentLatTextField_.text = [NSString stringFromFloat:_item.momentLat];
    } else if (sender == momentTextField_) {
        _item.moment = [momentTextField_.text floatValue];
        armTextField_.text = [NSString stringFromFloat:_item.arm];
    } else if (sender == momentLatTextField_) {
        _item.momentLat = [momentLatTextField_.text floatValue];
        armLatTextField_.text = [NSString stringFromFloat:_item.armLat];
    }
}

#pragma mark- UIAlertViewDelegate

- (void)alertView:(UIAlertView *)alertView didDismissWithButtonIndex:(NSInteger)buttonIndex {
    if (buttonIndex != alertView.cancelButtonIndex) {
        [_delegate cellDeleted:self];
    }
}

@end
